<h1 class="mb-4">Produkt: <?= htmlspecialchars($product->name) ?></h1>

<div class="card">
    <div class="card-header">
        <h5 class="card-title">Detaily produktu</h5>
    </div>
    <div class="card-body">
        <ul class="list-group list-group-flush">
            <li class="list-group-item"><strong>ID:</strong> <?= htmlspecialchars($product->id) ?></li>
            <li class="list-group-item"><strong>Kategorie:</strong> <?= htmlspecialchars($product->category) ?></li>
            <li class="list-group-item"><strong>Cena:</strong> <?= number_format((float)$product->price, 2, ',', ' ') ?> CZK</li>
            <li class="list-group-item"><strong>Sklad:</strong> <?= htmlspecialchars($product->stock) ?></li>
            <li class="list-group-item"><strong>Dodavatel:</strong> <?= htmlspecialchars($supplier->name ?? '-') ?></li>
            <li class="list-group-item"><strong>Vytvořeno:</strong> <?= htmlspecialchars($product->created_at ?? '') ?></li>
        </ul>
    </div>
    <div class="d-flex justify-content-between mt-4">
        <button type="submit" class="btn btn-success"><i class="bi bi-check-lg"></i></button>
        <a href="?controller=product&action=index" class="btn btn-secondary"><i class="bi bi-arrow-left"></i></a>
    </div>
</div>
